#ifndef _AUDIOSOURCES_H_
#define _AUDIOSOURCES_H_

#ifdef WIN32
#include "windows.h"
#endif



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
//
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
//#include <stl_pif.h>



class AudioSources
{
public:
   /// @brief Actually values of this Enum
   /// have to map exactly to the corresponding Index
   /// of the Rule item
   typedef enum {
      // use listing from file via macro to keep enum
      // and char array in sync
      #define ADD_AUDIOSOURCE(x) x,
      #include "AudioSourcesEnumeration.h"
      #undef ADD_AUDIOSOURCE
   } enAudioSources;

   static const char * SourceName[];
};


class AudioStates{
public:
    typedef enum {
      UNDEF          = 0,
      OFF            = 1,
      ON             = 2,
      PAUSE          = 3,
      RAMPDOWN2OFF   = 4,
      RAMPDOWN2PAUSE = 5,
      RAMPUP         = 6,
      RAMPUPINIT     = 7,
      RAMPUPREQUEST  = 8,
      WAIT_FOR       = 9,
      SRC_AVAILABLE  = 10
   } enAudioStates;
};

class AudioComponent
{
public:
   typedef enum {
      NONE           = 0,
      RADIO          = 1,
      MEDIA          = 2,
      RADIO_XM       = 3
   } enAudioComponent;

};

//}//namespace


#endif // _AUDIOSOURCES_H_
